<?php

class UserStudentLoginForm extends CFormModel
{
	public $login;
	public $password;

	private $identity;

	public function rules()
	{
		return array(
			array('login', 'safe'),
			array('password', 'authenticate'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'login'=>'E-mail:',
			'password'=>'Hasło:',
		);
	}

	public function authenticate($attribute,$params)
	{
		if(!$this->hasErrors())
		{
			$this->identity = new UserStudentIdentity($this->login, $this->password);

			if(!$this->identity->authenticate())
			{
				if($this->identity->errorCode == UserStudentIdentity::ERROR_USER_STATUS_INACTIVE)
					$this->addError('login', ParametryGry::model()->find('"nazwa"=\'KOMUNIKAT_BLEDU_LOGOWANIA_UZYTKOWNIK_NIEAKTYWNY\'')->wartosc);
				else if($this->identity->errorCode != CUserIdentity::ERROR_NONE)
					$this->addError('login', 'Błędne dane.');
			}
		}
	}

	public function login()
	{
		if($this->identity === null)
		{
			$this->identity = new UserStudentIdentity($this->login, $this->password);
			$this->identity->authenticate();
		}

		if($this->identity->errorCode === UserStudentIdentity::ERROR_NONE)
		{
			Yii::app()->user->login($this->identity, 0);
			return true;
		}
		else
			return false;
	}

	public function logout()
	{
		if($this->identity->errorCode === UserStudentIdentity::ERROR_NONE)
		{
			$this->identity = null;
			Yii::app()->user->logout();
			return true;
		}

		return false;
	}
}
